PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144683208"
 Author = "jayas.jayas"
 Desc = "Parallel Transmission Line with T-Tap"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144682942
  Nodes = 
   {
   Output("BRKR",36,-36)
    {
    Type = Integer
    Dim  = [5]
    }
   Output("FLT",36,18)
    {
    Type = Integer
    }
   Input("FLTTYP",36,-18)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   Pen(Black)
   Line(36,-18,27,-18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.datalabel([1746,342],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([1746,396],3,0,-1)
    {
    Name = "B2T1"
    }
   0.datalabel([1746,450],3,0,-1)
    {
    Name = "B2T2"
    }
   -Wire-([702,810],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([738,810],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([1458,1440],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1458,1440],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1782,666],3,0,-1)
    {
    Name = "B3T1"
    }
   0.datalabel([1782,720],3,0,-1)
    {
    Name = "B3T2"
    }
   0.datalabel([1782,774],3,0,-1)
    {
    Name = "B4T1"
    }
   0.datalabel([1458,1296],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1458,1314],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1458,1332],6,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1458,1350],6,0,-1)
    {
    Name = "B4"
    }
   -ControlPanel-([1386,378],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 1386,378
    Extents = 0,0,216,126
    Switch(40688640)
    Slider(40468504)
    Slider(39695448)
    }
   0.datalabel([1782,828],3,0,-1)
    {
    Name = "B4T2"
    }
   0.tbreakn([1818,288],4,0,20)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   0.tbreakn([1854,666],4,0,110)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B3T1"
    TO2 = "B3T2"
    }
   0.var([1710,450],0,39695448,60)
    {
    Name = "B2T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "1.0"
    Units = ""
    Collect = "1"
    }
   0.var([1710,396],0,40468504,50)
    {
    Name = "B2T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2"
    Units = ""
    Collect = "1"
    }
   0.var([1710,342],0,40471224,40)
    {
    Name = "B1T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "1.0"
    Units = ""
    Collect = "1"
    }
   0.var([1746,828],0,40474112,160)
    {
    Name = "B4T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1746,774],0,40476968,150)
    {
    Name = "B4T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2"
    Units = "s"
    Collect = "1"
    }
   0.var([1746,720],0,40479824,130)
    {
    Name = "B3T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1746,666],0,40482680,90)
    {
    Name = "B3T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([1746,288],3,0,-1)
    {
    Name = "B1T1"
    }
   0.var([1710,288],0,40486432,10)
    {
    Name = "B1T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2"
    Units = ""
    Collect = "1"
    }
   -Wire-([1854,324],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1854,396],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1854,432],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([1800,378],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.logic([1890,432],6,0,240)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1908,756],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1854,738],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1908,666],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.logic([1944,684],0,0,260)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1908,666],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.logic([1944,792],6,0,280)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1908,846],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1908,846],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.datalabel([1458,1368],6,0,-1)
    {
    Name = "B5"
    }
   0.datalabel([846,828],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([702,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([738,846],0,0,-1)
    {
    Name = "Tfd"
    }
   0.var([1746,1026],0,40544400,200)
    {
    Name = "B5T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = ".31"
    Units = ""
    Collect = "1"
    }
   0.datalabel([1782,1026],3,0,-1)
    {
    Name = "B5T1"
    }
   0.datalabel([1782,1080],3,0,-1)
    {
    Name = "B5T2"
    }
   -ControlPanel-([72,234],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(41758824)
    Meter(41801368)
    Slider(41761624)
    Meter(41729040)
    Meter(41506064)
    Meter(41502968)
    Meter(41578176)
    Meter(41712728)
    }
   -ControlPanel-([72,360],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(41764368)
    Meter(41795624)
    Slider(41767280)
    Meter(41414584)
    Meter(41682944)
    Meter(41704152)
    Meter(41581256)
    Meter(41718552)
    }
   -ControlPanel-([324,486],0)
    {
    Name = "Bus 5"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Meter(41755432)
    Meter(41615080)
    Meter(41709816)
    }
   0.export([1512,1404],4,0,370)
    {
    Name = "BRKR"
    }
   0.export([1548,1440],4,0,360)
    {
    Name = "FLT"
    }
   0.datalabel([1854,738],4,0,-1)
    {
    Name = "FLTTYP"
    }
   0.datalabel([1800,378],4,0,-1)
    {
    Name = "FLTTYP"
    }
   -Sticky-([72,684],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,684,180,720
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   0.tfaultn([810,828],4,0,270)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -Sticky-([1386,162],0)
    {
    Name = ""
    Font = 1
    Bounds = 1386,162,1494,198
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -ControlPanel-([1386,234],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 1386,234
    Extents = 0,0,216,126
    Switch(40685256)
    Slider(40486432)
    Slider(40471224)
    }
   -ControlPanel-([1386,630],0)
    {
    Name = "B3 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 1386,630
    Extents = 0,0,216,126
    Switch(40696376)
    Slider(40482680)
    Slider(40479824)
    }
   0.datamerge([1476,1368],4,0,350)
    {
    N = "5"
    Type = "1"
    Disp = "1"
    }
   -Sticky-([72,162],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,162,198,198
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -Sticky-([576,90],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 576,90,738,198
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.tbreakn([1818,486],4,0,80)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   -Sticky-([1710,162],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1710,162,1890,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   0.logic([1890,324],0,0,230)
    {
    Type = "1"
    Inv = "0"
    }
   0.datalabel([1998,288],6,0,-1)
    {
    Name = "B1"
    }
   0.var_switch([1890,288],0,40685256,30)
    {
    Name = "42 B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.datalabel([1998,468],4,0,-1)
    {
    Name = "B2"
    }
   0.var_switch([1890,468],0,40688640,70)
    {
    Name = "42 B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.logic([1962,288],0,0,330)
    {
    Type = "2"
    Inv = "0"
    }
   0.logic([1962,468],6,0,250)
    {
    Type = "2"
    Inv = "0"
    }
   0.logic([2016,828],6,0,290)
    {
    Type = "2"
    Inv = "0"
    }
   0.datalabel([2052,828],4,0,-1)
    {
    Name = "B4"
    }
   0.logic([2016,648],0,0,340)
    {
    Type = "2"
    Inv = "0"
    }
   0.datalabel([2052,648],2,0,-1)
    {
    Name = "B3"
    }
   0.var_switch([1944,648],0,40696376,100)
    {
    Name = "42 B3"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.var_switch([1944,828],0,40698960,170)
    {
    Name = "42 B4"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.var([1746,1080],0,40701680,220)
    {
    Name = "B5T2"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2"
    Units = ""
    Collect = "1"
    }
   -Wire-([1890,1044],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.logic([1980,1008],0,0,310)
    {
    Type = "1"
    Inv = "0"
    }
   0.logic([2052,1008],6,0,320)
    {
    Type = "2"
    Inv = "0"
    }
   0.datalabel([2088,1008],4,0,-1)
    {
    Name = "B5"
    }
   0.var([666,810],0,40707592,120)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   0.var([666,846],0,40710368,140)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = ""
    Collect = "1"
    }
   0.import([1854,1044],0,0,210)
    {
    Name = "FLTTYP"
    }
   0.var_switch([1980,972],0,40713984,190)
    {
    Name = "42 B5"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.tbreakn([1854,846],4,0,180)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B4T1"
    TO2 = "B4T2"
    }
   0.tbreakn([1908,1008],4,0,300)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B5T1"
    TO2 = "B5T2"
    }
   -ControlPanel-([72,738],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(41741056)
    Dial(41749576)
    Slider(40707592)
    Slider(40710368)
    Slider(41938240)
    }
   -Sticky-([342,900],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 342,900,504,1116
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> no fault"
    }
   -Sticky-([612,900],0)
    {
    Name = ""
    Font = 1
    Bounds = 612,900,936,1044
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
An AB to ground Fault (Location 7, Type 4) is applied at the
Low Voltage Distribution bus, at 0.2 sec for a duration of 0.2 sec.

Breaker B5 is opened at 0.31 sec, and remains open throughout
the remainder of the simulation.
"
    }
   -Sticky-([72,900],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,900,324,1242
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source and  breakers 
          (B1 and B3)
  2=> FT2: 
          Between B1 and LINE1
  3=> FT3: 
          Between LINE2 and B2
  4=> FT4: 
          Between breakers (B3 and B4)
          and Source
  5=> FT5:
          Between B3 and LINE3
  6=> FT6:
          Between LINE4 and B4
  7=> FT7:
          Between B5 and load
  8=> FT8:
          Between LINE4
          and Transformer"
    }
   -ControlPanel-([1386,774],0)
    {
    Name = "B4 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 1386,774
    Extents = 0,0,216,126
    Switch(40698960)
    Slider(40476968)
    Slider(40474112)
    }
   -ControlPanel-([1386,1008],0)
    {
    Name = "B5  Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 1386,1008
    Extents = 0,0,216,126
    Switch(40713984)
    Slider(40544400)
    Slider(40701680)
    }
   -Sticky-([1404,1224],0)
    {
    Name = ""
    Font = 1
    Bounds = 1404,1224,1512,1260
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   -Sticky-([990,144],0)
    {
    Name = ""
    Font = 1
    Bounds = 990,144,1098,180
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Playback  Recorders"
    }
   -ControlPanel-([990,216],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(41932944)
    Slider(41877216)
    }
   -ControlPanel-([882,360],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,360,126
    Switch(41893216)
    Switch(41896056)
    Switch(41898720)
    Switch(41901608)
    Switch(41904264)
    }
   -Sticky-([972,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 972,504,1152,648
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, 
click on the switch.
On = Recorder will record data.
Off = Recorder will NOT
          record data.

You can turn on or off 
each recorder individually."
    }
   -Divider-([54,666],0)
    {
    Size(1278,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1332,54],0)
    {
    Size(0,1458)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([828,54],0)
    {
    Size(0,612)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1332,1188],0)
    {
    Size(828,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots_B2")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(3,24,"B2 B4")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([54,36],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,702,1152]
    Posn = [54,36]
    Icon = [-1,-1]
    Extents = 0,0,702,1152
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,702,277],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(41449328,"V2a",0,,,)
     Curve(41452240,"V2b",1,,,)
     Curve(41473528,"V2c",2,,,)
     }
    Graph([0,277],[0,0,702,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(41443640,"I2a",0,,,)
     Curve(41701072,"I2b",1,,,)
     Curve(41522248,"I2c",2,,,)
     }
    Graph([0,554],[0,0,702,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(41519472,"I20",0,,,)
     }
    PGraph([0,831],[0,0,702,258],"PolyGraph")
     {
     Options = 2
     Curve(41661848,"Br2b",1,,,1)
     Curve(41462032,"Br2a",0,,,1)
     Curve(41659096,"Br2c",2,,,1)
     }
    }
   -Plot-([810,36],0)
    {
    Title = "Plots at B4"
    Draw = 1
    Area = [0,0,702,1152]
    Posn = [810,36]
    Icon = [-1,-1]
    Extents = 0,0,702,1152
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,702,277],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(41653544,"V4a",0,,,)
     Curve(41664624,"V4b",1,,,)
     Curve(41561024,"V4c",2,,,)
     }
    Graph([0,277],[0,0,702,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(41563936,"I4a",0,,,)
     Curve(41566848,"I4b",1,,,)
     Curve(41569760,"I4c",2,,,)
     }
    Graph([0,554],[0,0,702,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(41715640,"I40",0,,,)
     }
    PGraph([0,831],[0,0,702,258],"PolyGraph")
     {
     Options = 2
     Curve(41395448,"Br4a",0,,,1)
     Curve(41707040,"Br4b",1,,,1)
     Curve(41688768,"Br4c",2,,,1)
     }
    }
   }
  }
 Module("Plots_B1")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B1 B3")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,18],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,738,1170]
    Posn = [18,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(41588600,"V1a",0,,,)
     Curve(41680112,"V1b",1,,,)
     Curve(41446416,"V1c",2,,,)
     }
    Graph([0,282],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(41508976,"I1a",0,,,)
     Curve(41525328,"I1b",1,,,)
     Curve(41511888,"I1c",2,,,)
     }
    Graph([0,563],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(41515664,"I10",0,,,)
     }
    PGraph([0,844],[0,0,738,263],"PolyGraph")
     {
     Options = 2
     Curve(41457736,"Br1a",0,,,1)
     Curve(41465568,"Br1b",1,,,1)
     Curve(41698296,"Br1c",2,,,1)
     }
    }
   -Plot-([792,18],0)
    {
    Title = "Plots at B3"
    Draw = 1
    Area = [0,0,738,1170]
    Posn = [792,18]
    Icon = [-1,-1]
    Extents = 0,0,738,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,738,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(41501424,"V3a",0,,,)
     Curve(41685856,"V3b",1,,,)
     Curve(41600192,"V3c",2,,,)
     }
    Graph([0,282],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(41549288,"I3a",0,,,)
     Curve(41552288,"I3b",1,,,)
     Curve(41555200,"I3c",2,,,)
     }
    Graph([0,563],[0,0,738,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(41558112,"I30",0,,,)
     }
    PGraph([0,844],[0,0,738,263],"PolyGraph")
     {
     Options = 2
     Curve(41656320,"Br3a",0,,,)
     Curve(41572624,"Br3b",1,,,)
     Curve(41575400,"Br3c",2,,,)
     }
    }
   }
  }
 Module("Plots_1")
  {
  Desc = ""
  FileDate = 1144682941
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(1,22,"B5")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([36,54],0)
    {
    Title = "Substation B5"
    Draw = 1
    Area = [0,0,0,0]
    Posn = [36,54]
    Icon = [-1,-1]
    Extents = 0,0,1476,1116
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,1476,268],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(41627640,"V5a",0,,,)
     Curve(41695384,"V5b",1,,,)
     Curve(41630608,"V5c",2,,,)
     }
    Graph([0,268],[0,0,1476,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(41633408,"I5a",0,,,)
     Curve(41636376,"I5b",1,,,)
     Curve(41639288,"I5c",2,,,)
     }
    Graph([0,536],[0,0,1476,268],"Current")
     {
     Options = 9
     Units = ""
     Curve(41642200,"I50",0,,,)
     }
    PGraph([0,804],[0,0,1476,249],"PolyGraph")
     {
     Options = 2
     Curve(41648168,"Br5a",0,,,1)
     Curve(41607104,"Br5b",1,,,1)
     Curve(41610808,"Br5c",2,,,1)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.datalabel([1026,720],4,0,-1)
    {
    Name = "FT4"
    }
   0.pgb([1944,306],0,41395448,1450)
    {
    Name = "Br4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   -Wire-([2106,684],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([2124,720],0,0,240)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2124,756],0,0,260)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1908,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1908,432],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1908,378],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1908,342],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1782,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1782,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1782,432],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1782,144],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1782,180],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1782,216],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2268,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2268,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2268,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1908,144],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1908,180],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1764,378],0,0,610)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1764,342],0,0,600)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1764,306],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1764,342],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1764,378],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2124,792],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2124,756],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2124,720],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([2124,792],0,0,290)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1764,306],0,0,590)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1746,270],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([2196,900],0,41414584,320)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datalabel([2016,1170],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([2052,1170],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([2088,1170],2,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([2016,1476],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([2052,1476],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([2088,1476],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([1026,738],4,0,-1)
    {
    Name = "F4"
    }
   -Wire-([1782,540],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1782,252],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([828,792],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.datalabel([378,702],4,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([378,720],4,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([810,540],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([810,558],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([810,828],0,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([810,846],0,0,-1)
    {
    Name = "F6"
    }
   0.datalabel([1764,1458],2,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1692,1458],2,0,-1)
    {
    Name = "B1"
    }
   0.datatap([1728,1458],6,0,700)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1692,1458],6,0,710)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2160,1170],2,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([2196,1170],2,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([2124,1476],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([2196,1476],0,0,-1)
    {
    Name = "F6"
    }
   0.datalabel([594,540],0,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([594,558],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([594,828],0,0,-1)
    {
    Name = "FT5"
    }
   -Wire-([576,792],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([540,522],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([432,630],0,0,-1)
    {
    Vertex="0,0;-144,0"
    }
   0.datalabel([2142,270],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([2142,306],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([2142,342],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([2142,558],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([2142,594],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([2178,558],0,41443640,1210)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "0.8"
    }
   0.pgb([2178,216],0,41446416,1520)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([2178,432],0,41449328,60)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([2178,468],0,41452240,80)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.datalabel([2268,144],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([2268,180],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([2268,216],0,0,-1)
    {
    Name = "Br1C"
    }
   0.pgb([2304,144],0,41457736,1570)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([2268,432],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([2268,468],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([2304,432],0,41462032,1270)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([2268,270],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([2304,180],0,41465568,1540)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([2124,144],0,0,560)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2124,180],0,0,570)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2106,108],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([2142,144],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([2142,180],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([2142,468],2,0,-1)
    {
    Name = "V2B"
    }
   0.pgb([2178,504],0,41473528,100)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   -Wire-([2268,342],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2268,342],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([2268,378],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2268,378],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([2268,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2268,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2268,666],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([2142,432],2,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([2268,630],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([2268,594],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2268,594],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([2268,558],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2268,558],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([2268,504],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2268,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2268,432],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2268,504],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([2142,630],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([2142,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2142,594],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2142,558],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2142,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2142,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2142,342],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2268,144],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2268,180],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2268,216],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2268,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2268,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2142,504],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([2124,504],0,0,90)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2124,468],0,0,70)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([2124,432],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2124,468],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2124,504],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([2142,216],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([2124,216],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2124,180],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2124,144],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([2124,216],0,0,580)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2268,306],0,0,-1)
    {
    Name = "Q1"
    }
   0.datatap([2124,432],0,0,50)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2106,396],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([2106,396],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([2304,306],0,41502968,1410)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([2304,270],0,41506064,1460)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([2178,270],0,41508976,1470)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "0.8"
    }
   0.pgb([2178,342],0,41511888,1400)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "0.8"
    }
   -Wire-([2142,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2142,378],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([2178,378],0,41515664,1350)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0e-012"
    Max = "2.0e-012"
    }
   0.datalabel([2142,666],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([2178,666],0,41519472,1100)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0e-012"
    Max = "2.0e-012"
    }
   0.pgb([2178,630],0,41522248,1140)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "0.8"
    }
   0.pgb([2178,306],0,41525328,1440)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "0.8"
    }
   -Wire-([2106,108],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([2142,378],0,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([2106,684],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([2142,720],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([2142,756],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([2142,792],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1782,306],2,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([1782,342],2,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([1782,378],2,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([1782,144],0,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([1782,180],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1782,216],0,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([1782,252],0,0,-1)
    {
    Name = "I30"
    }
   0.datalabel([1782,432],0,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([1782,468],0,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([1782,504],0,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([1782,540],0,0,-1)
    {
    Name = "I40"
    }
   0.datalabel([1908,144],0,0,-1)
    {
    Name = "P3"
    }
   0.datalabel([1908,180],0,0,-1)
    {
    Name = "Q3"
    }
   0.datalabel([2268,720],0,0,-1)
    {
    Name = "Br3A"
    }
   0.datalabel([2268,756],0,0,-1)
    {
    Name = "Br3B"
    }
   0.datalabel([2268,792],0,0,-1)
    {
    Name = "Br3C"
    }
   -Wire-([1908,306],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1908,306],0,0,-1)
    {
    Name = "Br4A"
    }
   0.datalabel([1908,342],0,0,-1)
    {
    Name = "Br4B"
    }
   0.datalabel([1908,378],0,0,-1)
    {
    Name = "Br4C"
    }
   0.datalabel([1908,432],0,0,-1)
    {
    Name = "P4"
    }
   0.datalabel([1908,468],0,0,-1)
    {
    Name = "Q4"
    }
   0.pgb([1818,144],0,41549288,1620)
    {
    Name = "I3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.3"
    Max = "0.4"
    }
   0.pgb([1818,180],0,41552288,1590)
    {
    Name = "I3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.3"
    Max = "0.4"
    }
   0.pgb([1818,216],0,41555200,1560)
    {
    Name = "I3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.3"
    Max = "0.4"
    }
   0.pgb([1818,252],0,41558112,1530)
    {
    Name = "I30"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0e-012"
    Max = "3.0e-012"
    }
   0.pgb([1818,378],0,41561024,1390)
    {
    Name = "V4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1818,432],0,41563936,1320)
    {
    Name = "I4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.4"
    Max = "0.3"
    }
   0.pgb([1818,468],0,41566848,1300)
    {
    Name = "I4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.4"
    Max = "0.3"
    }
   0.pgb([1818,504],0,41569760,1260)
    {
    Name = "I4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.4"
    Max = "0.3"
    }
   0.pgb([2304,756],0,41572624,1010)
    {
    Name = "Br3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2304,792],0,41575400,990)
    {
    Name = "Br3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1944,144],0,41578176,1610)
    {
    Name = "P3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1944,432],0,41581256,1310)
    {
    Name = "P4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.datalabel([594,846],0,0,-1)
    {
    Name = "F5"
    }
   0.datalabel([1800,1458],2,0,-1)
    {
    Name = "B4"
    }
   0.breaker3([468,792],4,0,730)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B3"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I3A"
    IBRB = "I3B"
    IBRC = "I3C"
    IBR0 = "I30"
    SBRA = "Br3A"
    SBRB = "Br3B"
    SBRC = "Br3C"
    BP = "P3"
    BQ = "Q3"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-75.19"
    Q = "5.245"
    }
   0.pgb([2178,144],0,41588600,1600)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([2196,936],0,41591568,330)
    {
    Name = "V3rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([864,792],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.breaker3([936,792],0,0,720)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B4"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I4A"
    IBRB = "I4B"
    IBRC = "I4C"
    IBR0 = "I40"
    SBRA = "Br4A"
    SBRB = "Br4B"
    SBRC = "Br4C"
    BP = "P4"
    BQ = "Q4"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "76.62"
    Q = "-19.15"
    }
   0.datalabel([1836,1458],2,0,-1)
    {
    Name = "B5"
    }
   0.datatap([1836,1458],6,0,660)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([396,666],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.pgb([2178,792],0,41600192,300)
    {
    Name = "V3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   -Wire-([1908,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1908,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1908,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1908,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1908,594],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1908,594],0,0,-1)
    {
    Name = "Br5A"
    }
   0.datalabel([1908,630],0,0,-1)
    {
    Name = "Br5B"
    }
   0.pgb([1944,630],0,41607104,1150)
    {
    Name = "Br5b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([1908,666],0,0,-1)
    {
    Name = "Br5C"
    }
   0.pgb([1944,666],0,41610808,1130)
    {
    Name = "Br5c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([1908,720],0,0,-1)
    {
    Name = "P5"
    }
   0.datalabel([1908,756],0,0,-1)
    {
    Name = "Q5"
    }
   0.pgb([1944,720],0,41615080,1060)
    {
    Name = "P5"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   -Wire-([1746,558],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1764,594],0,0,130)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1764,630],0,0,150)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1782,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1782,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1782,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1764,666],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1764,630],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1764,594],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1764,666],0,0,190)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1782,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1746,558],2,0,-1)
    {
    Name = "V5"
    }
   0.datalabel([1782,594],2,0,-1)
    {
    Name = "V5A"
    }
   0.datalabel([1782,630],2,0,-1)
    {
    Name = "V5B"
    }
   0.datalabel([1782,666],2,0,-1)
    {
    Name = "V5C"
    }
   0.pgb([1818,594],0,41627640,140)
    {
    Name = "V5a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-20.0"
    Max = "20.0"
    }
   0.pgb([1818,666],0,41630608,210)
    {
    Name = "V5c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-20.0"
    Max = "20.0"
    }
   0.pgb([1818,720],0,41633408,1070)
    {
    Name = "I5a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-15.0"
    Max = "20.0"
    }
   0.pgb([1818,756],0,41636376,1050)
    {
    Name = "I5b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-15.0"
    Max = "20.0"
    }
   0.pgb([1818,792],0,41639288,1020)
    {
    Name = "I5c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-15.0"
    Max = "20.0"
    }
   0.pgb([1818,828],0,41642200,1000)
    {
    Name = "I50"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-6.0"
    Max = "8.0"
    }
   0.datalabel([1782,828],0,0,-1)
    {
    Name = "I50"
    }
   0.datalabel([1782,792],0,0,-1)
    {
    Name = "I5C"
    }
   0.datalabel([1782,756],0,0,-1)
    {
    Name = "I5B"
    }
   0.datalabel([1782,720],0,0,-1)
    {
    Name = "I5A"
    }
   0.pgb([1944,594],0,41648168,1190)
    {
    Name = "Br5a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([2232,1170],6,0,-1)
    {
    Name = "FT7"
    }
   0.datalabel([2232,1476],4,0,-1)
    {
    Name = "F7"
    }
   0.datalabel([1746,270],2,0,-1)
    {
    Name = "V4"
    }
   0.pgb([1818,306],0,41653544,1480)
    {
    Name = "V4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([2304,720],0,41656320,1030)
    {
    Name = "Br3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2304,504],0,41659096,1220)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2304,468],0,41661848,1250)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1818,342],0,41664624,1430)
    {
    Name = "V4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.datatap([2016,1170],6,0,950)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2052,1170],6,0,940)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2088,1170],6,0,930)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2124,1170],6,0,920)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2160,1170],6,0,910)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([2088,1260],0,0,-1)
    {
    Vertex="0,0;0,126"
    }
   0.datatap([2052,1476],0,0,830)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2088,1476],0,0,820)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2124,1476],0,0,810)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2160,1476],0,0,800)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2232,1476],0,0,780)
    {
    Index = "7"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2124,1170],2,0,-1)
    {
    Name = "FT4"
    }
   0.datalabel([2160,1476],0,0,-1)
    {
    Name = "F5"
    }
   0.pgb([2178,180],0,41680112,1550)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([2304,558],0,41682944,1200)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([2178,756],0,41685856,270)
    {
    Name = "V3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1944,378],0,41688768,1370)
    {
    Name = "Br4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2178,720],0,41501424,250)
    {
    Name = "V3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1818,630],0,41695384,170)
    {
    Name = "V5b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-20.0"
    Max = "20.0"
    }
   0.pgb([2304,216],0,41698296,1510)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([2178,594],0,41701072,1170)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "0.8"
    }
   0.pgb([2304,594],0,41704152,1160)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1944,342],0,41707040,1420)
    {
    Name = "Br4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1944,756],0,41709816,1040)
    {
    Name = "Q5"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1944,180],0,41712728,1580)
    {
    Name = "Q3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1818,540],0,41715640,1240)
    {
    Name = "I40"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0e-012"
    Max = "3.0e-012"
    }
   0.pgb([1944,468],0,41718552,1280)
    {
    Name = "Q4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   -Sticky-([1674,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 1674,36,1782,72
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.datatap([1764,1458],6,0,680)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1494,954],4,0,-1)
    {
    Name = "Breaker"
    }
   0.datalabel([1656,1476],0,0,-1)
    {
    Name = "Breaker"
    }
   0.datatap([2016,1476],0,0,840)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.breaker3([468,522],4,0,750)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-75.01"
    Q = "1.673"
    }
   -Wire-([972,630],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.pgb([2196,864],0,41729040,310)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([2196,972],0,41732080,350)
    {
    Name = "V4rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.breaker3([936,522],0,0,740)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "77.01"
    Q = "-22.74"
    }
   -Wire-([1008,666],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([972,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([396,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.mux_array([2106,1224],0,0,870)
    {
    DPath = "0"
    }
   0.mux_array([2106,1422],6,0,690)
    {
    DPath = "0"
    }
   0.var_pot([2016,1314],0,41741056,520)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "8"
    Value = "7"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([2088,1314],0,0,530)
    {
    IType = "2"
    OType = "1"
    }
   -Wire-([1224,324],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([1224,324],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   0.datalabel([1494,972],4,0,-1)
    {
    Name = "Faulttype"
    }
   0.unity([2124,1314],4,0,640)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([2124,1314],0,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([2124,1368],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.datalabel([2124,1368],2,0,-1)
    {
    Name = "Fault"
    }
   0.var_pot([2196,1314],2,41749576,540)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "4"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   -Wire-([2124,1260],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   0.resistive_load([1296,324],0,0,-1)
    {
    P = "40.0 [MW]"
    V = "24.0 [kV]"
    SD = "0"
    }
   0.reactive_load([1368,324],0,0,-1)
    {
    S = "10.0 [MVAR]"
    V = "24.0 [kV]"
    F = "$(f)"
    SD = "0"
    }
   0.ground([1008,360],1,0,-1)
    {
    }
   0.pgb([2196,1008],0,41755432,380)
    {
    Name = "V5rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "20"
    Max = "27"
    }
   0.var([270,702],3,41758824,120)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([216,702],3,41761624,110)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "240.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([1098,702],5,41764368,160)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([1152,702],5,41767280,180)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "240.0"
    Units = "kV"
    Collect = "1"
    }
   0.source3R([252,630],6,0,1290)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.source3R([1116,630],2,0,620)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.xfmr-3p2w([1008,324],0,0,-1)
    {
    Name = "Trans 1 "
    Tmva = "50.0 [MVA]"
    f = "$(f)"
    YD1 = "1"
    YD2 = "0"
    Lead = "1"
    Xl = "0.1 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "230.0 [kV]"
    V2 = "25 [kV]"
    Enab = "1"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [s]"
    Im1 = "1 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   -Wire-([1728,1386],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1800,1386],0,0,-1)
    {
    Name = "Ron"
    }
   0.tpflt([414,684],4,0,1230)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([558,522],0,0,1360)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([558,810],0,0,1110)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([990,702],0,0,1180)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.annotation([1692,1368],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.datatap([2196,1476],0,0,790)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.tpflt([846,810],4,0,1090)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datatap([2196,1170],6,0,900)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1998,1188],0,0,-1)
    {
    Vertex="0,0;270,0"
    }
   0.datatap([2232,1170],6,0,890)
    {
    Index = "7"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2268,1170],6,0,880)
    {
    Index = "8"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2268,1170],6,0,-1)
    {
    Name = "FT8"
    }
   -Wire-([1998,1458],0,0,-1)
    {
    Vertex="0,0;270,0"
    }
   0.datatap([2268,1476],0,0,770)
    {
    Index = "8"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([2268,1476],4,0,-1)
    {
    Name = "F8"
    }
   0.pgb([2304,630],0,41795624,1120)
    {
    Name = "PS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([2304,666],0,41798592,1080)
    {
    Name = "QS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([2304,342],0,41801368,1380)
    {
    Name = "PS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([2304,378],0,41804336,1330)
    {
    Name = "QS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   -Bus-([972,486],0,24579424,-1)
    {
    P1 = [0,0]
    P2 = [0,342]
    I = 1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   -Bus-([432,450],0,115139752,-1)
    {
    P1 = [0,0]
    P2 = [0,378]
    I = 1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   -Bus-([702,288],0,115140280,-1)
    {
    P1 = [0,0]
    P2 = [0,270]
    I = 1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   -Bus-([918,288],0,24648632,-1)
    {
    P1 = [0,0]
    P2 = [0,72]
    I = 1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.datalabel([936,378],0,0,-1)
    {
    Name = "FT8"
    }
   -Wire-([1818,1476],0,0,-1)
    {
    Vertex="0,0;-162,0"
    }
   0.datalabel([450,1152],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([486,1152],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([522,1152],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([450,1332],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([486,1332],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([522,1332],2,0,-1)
    {
    Name = "I2C"
    }
   0.datalabel([342,1152],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([378,1152],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([414,1152],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([342,1332],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([378,1332],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([414,1332],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([774,1440],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([774,1260],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([828,1152],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([864,1152],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([900,1152],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([828,1332],6,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([864,1332],6,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([900,1332],6,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([936,1152],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([972,1152],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1008,1152],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([936,1332],2,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([972,1332],2,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([1008,1332],2,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([522,1296],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([522,1476],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1008,1296],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1008,1476],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1422,1152],2,0,-1)
    {
    Name = "I5B"
    }
   0.datalabel([1386,1152],2,0,-1)
    {
    Name = "I5A"
    }
   0.datalabel([1350,1152],6,0,-1)
    {
    Name = "V5C"
    }
   0.datalabel([1314,1152],6,0,-1)
    {
    Name = "V5B"
    }
   0.datalabel([1278,1152],6,0,-1)
    {
    Name = "V5A"
    }
   0.recorder2_0([414,1224],0,0,980)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   -Wire-([774,1260],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   0.const([90,1188],1,0,360)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([126,1224],6,0,630)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.recorder2_0([900,1404],0,0,850)
    {
    FName = "stn4"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "4"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([414,1404],0,0,860)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   -Wire-([1188,1260],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([234,1260],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([234,1548],0,0,-1)
    {
    Vertex="0,0;954,0"
    }
   0.var([180,1260],0,41877216,420)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   0.const([108,1368],1,0,470)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([144,1404],6,0,490)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([180,1404],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([72,1116],0,0,-1)
    {
    Vertex="0,0;0,324"
    }
   -Wire-([234,1440],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([72,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([216,1260],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([72,1260],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([648,1188],1,0,390)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([684,1224],6,0,430)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([648,1368],1,0,500)
    {
    Name = ""
    Value = "10.0"
    }
   0.const([1098,1188],1,0,440)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([1134,1224],6,0,450)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.select([684,1404],6,0,510)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([594,1116],0,0,-1)
    {
    Vertex="0,0;0,324"
    }
   -Wire-([720,1404],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([594,1440],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([594,1260],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([72,1116],0,0,-1)
    {
    Vertex="0,0;990,0"
    }
   -Wire-([1062,1116],0,0,-1)
    {
    Vertex="0,0;0,144"
    }
   -Wire-([1242,1260],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([1098,1260],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.var_switch([126,1152],1,41893216,340)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([144,1332],1,41896056,460)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([684,1152],1,41898720,370)
    {
    Name = "en Record3"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([684,1332],1,41901608,480)
    {
    Name = "en Record4"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([1134,1152],1,41904264,410)
    {
    Name = "en Record5"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   -Wire-([162,1224],0,0,-1)
    {
    Vertex="0,0;144,0"
    }
   -Wire-([720,1224],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1242,1224],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.datalabel([1458,1152],2,0,-1)
    {
    Name = "I5C"
    }
   0.datalabel([1458,1296],0,0,-1)
    {
    Name = "Fault"
    }
   0.recorder2_0([900,1224],0,0,970)
    {
    FName = "stn3"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "3"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datatap([1800,1458],6,0,670)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.recorder2_0([1350,1224],0,0,960)
    {
    FName = "stn5"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "5"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.var([36,1260],0,41932944,400)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   .Plots_1([936,234],0,0,10)
    {
    }
   .Plots_B1([468,882],0,0,230)
    {
    }
   .Plots_B2([936,882],0,0,280)
    {
    }
   0.var([1692,1386],0,41938240,550)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   0.datalabel([1728,1458],2,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1494,1008],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1530,1008],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([1494,972],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1530,954],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -TLine-([594,522],0,123332592,-1)
    {
    Name = "LINE1"
    Date = 1144682942
    Freq = "$(f)"
    Length = "50 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;90,0;108,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_Ground([630,702],0,33228344,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_FrePhase_Options([216,468],0,100283504,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.SequenceInfo([612,198],0,100283976,-1)
      {
      Mode = "0"
      X1 = "1.787240475"
      Y1 = "25.3881338"
      X2 = "1.787240475"
      Y2 = "25.3881338"
      X3 = "18.15761005"
      Y3 = "66.3236615"
      X4 = "5.0e-006"
      Y4 = "0.000163558973"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "5.0e-006"
      Y6 = "0.000116133049"
      M1 = "25.4509639574"
      P1 = "85.9732100966"
      M2 = "25.4509639574"
      P2 = "85.9732100966"
      M3 = "68.7642848977"
      P3 = "74.6891426178"
      M4 = "0.000163635380187"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000116240634333"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([810,612],0,100284928,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mhos/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -TLine-([702,522],0,22882416,-1)
    {
    Name = "LINE2"
    Date = 1144682943
    Freq = "$(f)"
    Length = "50 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;90,0;108,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_Ground([630,702],0,22883560,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_FrePhase_Options([216,468],0,22884488,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.SequenceInfo([594,198],0,22885048,-1)
      {
      Mode = "0"
      X1 = "1.787240475"
      Y1 = "25.3881338"
      X2 = "1.787240475"
      Y2 = "25.3881338"
      X3 = "18.15761005"
      Y3 = "66.3236615"
      X4 = "5.0e-006"
      Y4 = "0.000163558973"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "5.0e-006"
      Y6 = "0.000116133049"
      M1 = "25.4509639574"
      P1 = "85.9732100966"
      M2 = "25.4509639574"
      P2 = "85.9732100966"
      M3 = "68.7642848977"
      P3 = "74.6891426178"
      M4 = "0.000163635380187"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000116240634333"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([810,612],0,109135640,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mhos/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "C:\\home\\user\\pscad\\lineconstants\\database\\acsr.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "C:\\home\\user\\pscad\\lineconstants\\database\\gw.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -Wire-([540,792],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.tpflt([846,522],4,0,1340)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Wire-([864,522],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -TLine-([594,792],0,127601736,-1)
    {
    Name = "LINE3"
    Date = 1144682944
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_Ground([630,702],0,79840696,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_FrePhase_Options([216,468],0,79841824,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.SequenceInfo([594,198],0,89878776,-1)
      {
      Mode = "0"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([810,612],0,89879744,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mhos/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -Sticky-([198,522],0)
    {
    Name = ""
    Font = 1
    Bounds = 198,522,288,558
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   -Sticky-([1062,522],0)
    {
    Name = ""
    Font = 1
    Bounds = 1062,522,1152,558
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   0.tpflt([900,360],0,0,1500)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Bus-([1224,288],0,32064880,-1)
    {
    P1 = [0,0]
    P2 = [0,72]
    I = 1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.tpflt([1206,360],0,0,1490)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "1"
    }
   0.datalabel([1242,378],0,0,-1)
    {
    Name = "FT7"
    }
   0.datalabel([1242,396],0,0,-1)
    {
    Name = "F7"
    }
   0.datalabel([936,396],0,0,-1)
    {
    Name = "F8"
    }
   -Sticky-([990,216],0)
    {
    Name = ""
    Font = 1
    Bounds = 990,216,1080,252
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION  3"
    }
   -TLine-([918,324],0,34761488,-1)
    {
    Name = "LINE4"
    Date = 1144682944
    Freq = "$(f)"
    Length = "50 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;-18,0;-198,0;-216,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_Ground([630,702],0,127601208,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_FrePhase_Options([216,486],0,119187352,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.SequenceInfo([594,198],0,119187952,-1)
      {
      Mode = "0"
      X1 = "1.787240475"
      Y1 = "25.3881338"
      X2 = "1.787240475"
      Y2 = "25.3881338"
      X3 = "18.15761005"
      Y3 = "66.3236615"
      X4 = "5.0e-006"
      Y4 = "0.000163558973"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "5.0e-006"
      Y6 = "0.000116133049"
      M1 = "25.4509639574"
      P1 = "85.9732100966"
      M2 = "25.4509639574"
      P2 = "85.9732100966"
      M3 = "68.7642848977"
      P3 = "74.6891426178"
      M4 = "0.000163635380187"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000116240634333"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([810,612],0,119188904,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mhos/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     }
    }
   -Wire-([918,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   .Controls([1566,990],4,0,650)
    {
    }
   0.breaker3([1080,324],4,0,760)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B5"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I5A"
    IBRB = "I5B"
    IBRC = "I5C"
    IBR0 = "I50"
    SBRA = "Br5A"
    SBRB = "Br5B"
    SBRC = "Br5C"
    BP = "P5"
    BQ = "Q5"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "0.002679"
    Q = "0.009953"
    }
   -Sticky-([36,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 36,36,468,252
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Case Description: 
- Two Thevinen Impedance sources connected via
   transmission lines and a T-tap.
- One transmission line terminated with a transformer
  of configurable size and type.
- System voltage is 230kV settable via source equivalents.
- Simulates three substations connected via three transmission lines.
- Eight (8) fault positions for full fault control ahead and behind station relays.
- Five breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible."
    }
   -Sticky-([792,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 792,36,1188,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   -Divider-([18,1062],0)
    {
    Size(2358,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1656,36],0)
    {
    Size(0,1026)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   0.multimeter([522,522],0,0,30)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([522,792],0,0,200)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V3"
    P = ""
    Q = ""
    Vrms = "V3rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([882,522],4,0,40)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([882,792],4,0,220)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V4"
    P = ""
    Q = ""
    Vrms = "V4rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([1134,324],0,0,20)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V5"
    P = ""
    Q = ""
    Vrms = "V5rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([2160,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2160,864],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([2160,900],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2160,900],0,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([2160,936],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2160,936],0,0,-1)
    {
    Name = "V3rms"
    }
   -Wire-([2160,972],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2160,972],0,0,-1)
    {
    Name = "V4rms"
    }
   -Wire-([2160,1008],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2160,1008],0,0,-1)
    {
    Name = "V4rms"
    }
   }
  }
 }

